/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.AbstractCommandRunner;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class CommandScriptRunner
extends AbstractCommandRunner {
    private int _exitValue;
    private File _tempFile;

    public CommandScriptRunner(CommandElement command, CommandContext context) {
        super("Execute Command Script", command, context, null);
    }

    protected void afterExecute() {
        if (this._tempFile != null && this._tempFile.exists()) {
            this._tempFile.delete();
        }
    }

    protected void beforeExecute() throws IOException {
        this.createScriptFile();
    }

    protected String createScriptFile() throws IOException, FileNotFoundException {
        String OS = Platform.getOS();
        this._tempFile = File.createTempFile("command_temp_", ".sh");
        PrintWriter pw = new PrintWriter(this._tempFile);
        pw.print(this.getCommand().getInvoke());
        pw.close();
        return OS;
    }

    protected String[] getCommandLineArguments() {
        return new String[]{"-l", this._tempFile.getAbsolutePath()};
    }

    public String executeScript() {
        IPath shell;
        try {
            shell = ShellExecutable.getPath();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.CommandScriptRunner_CANNOT_LOCATE_SHELL, (Throwable)e);
            this._exitValue = 1;
            this.setExecutedSuccessfully(false);
            return MessageFormat.format(Messages.CommandScriptRunner_UNABLE_TO_LOCATE_SHELL_FOR_COMMAND, this.getCommand().getPath());
        }
        String[] commandLine = this.getCommandLineArguments();
        String resultText = null;
        String input = IOUtil.read((InputStream)this.getContext().getInputStream(), (String)"UTF-8");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandLine));
        args.add(0, shell.toOSString());
        IStatus result = new ProcessRunner().runInBackground(this.getCommand().getWorkingDirectory(), this.getContributedEnvironment(), input, args);
        if (result == null) {
            this._exitValue = 1;
            this.setExecutedSuccessfully(false);
        } else {
            this._exitValue = result.getCode();
            resultText = result.getMessage();
            this.setExecutedSuccessfully(this._exitValue == 0);
        }
        return resultText;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String resultText;
        block7: {
            resultText = "";
            try {
                try {
                    this.beforeExecute();
                    resultText = this.executeScript();
                }
                catch (IOException e) {
                    ScriptLogger.logError(e.getMessage());
                    this._exitValue = 1;
                    this.setExecutedSuccessfully(false);
                    this.afterExecute();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.afterExecute();
                throw throwable;
            }
            this.afterExecute();
        }
        CommandResult result = new CommandResult(this.getCommand(), this.getContext());
        result.setReturnValue(this._exitValue);
        result.setExecutedSuccessfully(this.getExecutedSuccessfully());
        if (result.executedSuccessfully()) {
            result.setOutputString(resultText);
        } else {
            result.setErrorString(resultText);
        }
        this.setCommandResult(result);
        return Status.OK_STATUS;
    }
}

